function [Sup,Average,StdDev,relmeas ,Loc] = Sup_Norm(tri, vert, f, Spline, n, thresh)
%Evaluate a sup norm over randomly selected set of discrete points in disc.
%   dt is the delaunay triangulation.  f is the function comparing the
%   spline to.  Spline is the quadratic C0 spline given as nodal over the
%   triangulation.  n^2 is the number of sample points.  n gives the random
%   number of points sampled in each tri and thresh is a cutoff for use with relmeas. 
%   At output, it
%   prints the total number of points sampled and stores the discrete
%   infinity norm of the error along with the average error discrete L2
%   stand deviation. relmeas is the percentage of sampled points in error falling at
%   or below the value thresh. Loc is the triangle index in which the max was observed.

%Remark: To understand meaning of stddev(=std) to its average (mu) do this.
%By markov: meas(|X-mu|>lambda std)<= ||X-mu||^2_2 / (lambda std)^2
%By def std: ||X-mu||^2_2 = int_Omega{|X-mu|^2}dm = meas(Omega)avgint_Omega{|X-mu|^2}dm = meas(Omega)std^2
%Conclusion: The RELATIVE MEASURE meas(|X-mu|>lambda std) / meas(Omega) <= 1/lambda^2

%In discrete case: meas is counting meas and all integrands are ISF, so
%conforms with our discrete case.  

numtri = size(tri,1);
numvert = size(vert,1);
numtest = n*numtri; %Total number of test points.

%Generate Lists
[Edge, Etri, Boundary, Vmem, Vnodal, Enodal, Nodal, Nodal_Bud, Nodes, Ntri, Nmem] = Lists(tri,vert);

%Do the first triangle:
%Get n random barycentric coordinates
r = rand(n,1);
s = rand(n,1); 
s = s.*(1-r); %Have s be sampled randomly from the interval length r allows
t = zeros(n,1) + 1 - r - s; 

Points = [r s t]*[vert(tri(1,1),:);vert(tri(1,2),:);vert(tri(1,3),:)]; %These are the points in 1st triangle.  Indeed [[x1 x2 x3];[y1 y2 y3]][[r s t]]^tr = Point^tr. transpose and get this                                                                   
ZF = arrayfun(f, Points(:,1), Points(:,2)); %Sample the function in 1st triangle. Notes points are two columns, the first x and the second y coordinates.

%Mimic the Q_Terp format
N = [Nodes(Ntri(1,1),:);Nodes(Ntri(1,2),:);Nodes(Ntri(1,3),:);Nodes(Ntri(1,4),:);Nodes(Ntri(1,5),:);Nodes(Ntri(1,6),:)]; %Get xy coords all nodes in 1st triangle. 1st column x coordinates and 2nd y.
p = [Spline(Ntri(1,1),1);Spline(Ntri(1,2),1);Spline(Ntri(1,3),1);Spline(Ntri(1,4),1);Spline(Ntri(1,5),1);Spline(Ntri(1,6),1)]; %Extract the spline values here
Coeffs = Q_Terp(N,p);                %Coeffs on {1, x, y, xy, x^2, y^2}
ZS = Coeffs(1,1)+ Coeffs(1,2)*Points(:,1) + Coeffs(1,3)*Points(:,2) + Coeffs(1,4)*Points(:,1).*Points(:,2) + Coeffs(1,5)*Points(:,1).^2+Coeffs(1,6)*Points(:,2).^2; %Evaluate the spline at these points.

for i=2:numtri %Do the other triangles
    %Get n random barycentric coordinates.
    r = rand(n,1);
    s = rand(n,1); 
    s = s.*(1-r); %Have s be sampled randomly from the interval length r allows
    t = zeros(n,1) + 1 - r - s; 
    
    Points = [r s t]*[vert(tri(i,1),:);vert(tri(i,2),:);vert(tri(i,3),:)]; %These are the points in 1st triangle.  Indeed [[x1 x2 x3];[y1 y2 y3]][[r s t]]^tr = Point^tr. transpose and get this                                                                   
    ZFnew = arrayfun(f, Points(:,1), Points(:,2)); %Sample the function in 1st triangle. Notes points are two columns, the first x and the second y coordinates.
    ZF = [ZF;ZFnew]; %Put the new points in bottom of old.
    %Mimic the Q_Terp format
    N = [Nodes(Ntri(i,1),:);Nodes(Ntri(i,2),:);Nodes(Ntri(i,3),:);Nodes(Ntri(i,4),:);Nodes(Ntri(i,5),:);Nodes(Ntri(i,6),:)]; %Get xy coords all nodes in 1st triangle. 1st column x coordinates and 2nd y.
    p = [Spline(Ntri(i,1),1);Spline(Ntri(i,2),1);Spline(Ntri(i,3),1);Spline(Ntri(i,4),1);Spline(Ntri(i,5),1);Spline(Ntri(i,6),1)]; %Extract the spline values here
    Coeffs = Q_Terp(N,p);                %Coeffs on {1, x, y, xy, x^2, y^2}
    ZSnew = Coeffs(1,1)+ Coeffs(1,2)*Points(:,1) + Coeffs(1,3)*Points(:,2) + Coeffs(1,4)*Points(:,1).*Points(:,2) + Coeffs(1,5)*Points(:,1).^2+Coeffs(1,6)*Points(:,2).^2; %Evaluate the spline at these points.
    ZS = [ZS;ZSnew]; %Again put the new points in the bottom.
end

numtri*n %Just to list total number of points sampled.
[Sup,Loc] = max(abs(ZF - ZS));
Loc = floor(Loc./n); %There are n*numtri samples so divinging by n returns which triangle we were at.

Average = sum(abs(ZF-ZS))/numtest;
StdDev = sqrt(1/numtest*sum((abs(ZF-ZS)-Average).^2));
relmeas = sum(1.*(abs(ZF-ZS)<=thresh))/numtest;
end

